/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.data.provider.DataChangeEvent;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;

public abstract class AbstractDataProvider<T, F>
implements DataProvider<T, F> {
    private HashMap<Class<?>, List<SerializableConsumer<?>>> listeners = new HashMap();

    @Override
    public Registration addDataProviderListener(final DataProviderListener<T> listener) {
        SerializableConsumer<DataChangeEvent> consumer = new SerializableConsumer<DataChangeEvent>(){

            public void accept(DataChangeEvent dataChangeEvent) {
                listener.onDataChange(dataChangeEvent);
            }
        };
        return this.addListener(DataChangeEvent.class, consumer);
    }

    @Override
    public void refreshAll() {
        this.fireEvent(new DataChangeEvent(this));
    }

    @Override
    public void refreshItem(T item, boolean refreshChildren) {
        this.fireEvent(new DataChangeEvent.DataRefreshEvent<T>(this, item, refreshChildren));
    }

    @Override
    public void refreshItem(T item) {
        this.fireEvent(new DataChangeEvent.DataRefreshEvent<T>(this, item));
    }

    protected <E> Registration addListener(Class<E> eventType, SerializableConsumer<E> method) {
        List list = this.listeners.computeIfAbsent(eventType, key -> new ArrayList());
        return Registration.addAndRemove((Collection)list, method);
    }

    protected void fireEvent(EventObject event) {
        this.listeners.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(event.getClass())).forEach(entry -> {
            for (Consumer consumer : (List)entry.getValue()) {
                consumer.accept(event);
            }
        });
    }
}

